(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28098,        778]
NotebookOptionsPosition[     27337,        752]
NotebookOutlinePosition[     27821,        771]
CellTagsIndexPosition[     27778,        768]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"ser", ",", "par"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ser", ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", "#"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"par", ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        SuperscriptBox["#", 
         RowBox[{"-", "1"}]], ")"}]}], ")"}], 
     RowBox[{"-", "1"}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]F", "=", 
    RowBox[{"1.0", "*", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.724741441703125*^9, 3.72474181171875*^9}, {
   3.724742126390625*^9, 3.724742242296875*^9}, {3.72474227340625*^9, 
   3.72474228321875*^9}, {3.724742512609375*^9, 3.72474269528125*^9}, {
   3.724744409953125*^9, 3.724744420546875*^9}, 3.724748290609375*^9, {
   3.725118802234375*^9, 3.725118809546875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataOstra", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Import", "[", "\"\<upr.xls\>\"", "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"f", ",", "re", ",", 
       RowBox[{"-", "im"}]}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fc", "=", 
   RowBox[{"First", "/@", "dataOstra"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"fmin", ",", "fmax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Min", "[", "fc", "]"}], ",", 
     RowBox[{"Max", "[", "fc", "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.724740628078125*^9, 3.724740633296875*^9}, {
  3.724741376046875*^9, 3.724741389703125*^9}, {3.724748349375*^9, 
  3.72474835221875*^9}, {3.724748413640625*^9, 3.724748417234375*^9}, {
  3.725118698765625*^9, 3.725118699984375*^9}, {3.725280265671875*^9, 
  3.725280277765625*^9}, {3.725280312078125*^9, 3.725280314234375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plOstra", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"dataOstra", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"re", ",", 
          RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Re[z] \[CapitalOmega]\>\"", ",", 
         "\"\<-Im[z] \[CapitalOmega]\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.724748380375*^9, 3.724748403859375*^9}, {
   3.724748435875*^9, 3.724748448671875*^9}, 3.7247485435*^9, {
   3.72511764378125*^9, 3.725117649234375*^9}, {3.725118703140625*^9, 
   3.72511870621875*^9}, {3.72528035346875*^9, 3.725280427828125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", "dataOstra"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "zMer1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zMer1", "[", "f_", "]"}], ":=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"Rs0", ",", 
      RowBox[{"par", "[", 
       RowBox[{"{", 
        RowBox[{"Rp1", ",", 
         FractionBox["1", 
          RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c1"}]]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fMez", "=", 
   RowBox[{"30.2", "*", 
    SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testVysoke", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "]"}], ":=", 
   RowBox[{"f", "\[GreaterEqual]", "fMez"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataFVysoka", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"data", ",", "testVysoke"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dataFVysoka", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"re", ",", 
         RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norm", ":=", 
   RowBox[{
    SuperscriptBox["#", "2"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"errVysoke", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"norm", "[", 
     RowBox[{"re", "-", 
      RowBox[{"Re", "[", 
       RowBox[{"zMer1", "[", "f", "]"}], "]"}]}], "]"}], "+", 
    RowBox[{"norm", "[", 
     RowBox[{"im", "-", 
      RowBox[{"Im", "[", 
       RowBox[{"zMer1", "[", "f", "]"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errCelkemVysoke", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"errVysoke", "/@", "dataFVysoka"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minVysoke", "=", 
   RowBox[{
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"{", "errCelkemVysoke", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c1", ",", 
        RowBox[{"0.05", "\[Mu]F"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Rp1", ",", "20000"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Rs0", ",", "50"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zVysoke", "[", "f_", "]"}], ":=", 
   RowBox[{
    RowBox[{"zMer1", "[", "f", "]"}], "/.", "minVysoke"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bodVysoke", "[", "f_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"zVysoke", "[", "f", "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"zVysoke", "[", "f", "]"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fVysoke", "=", 
   RowBox[{"First", "/@", "dataFVysoka"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"fminV", ",", "fmaxV"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Min", "[", "fVysoke", "]"}], ",", 
     RowBox[{"Max", "[", "fVysoke", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bodVysoke", "[", "f", "]"}], "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"re", ",", 
         RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "fminV", ",", "fmaxV"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "300"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", "pl2"}], "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7247445924375*^9, 3.724744743578125*^9}, {
   3.724744773625*^9, 3.72474478528125*^9}, {3.724744823671875*^9, 
   3.724745619453125*^9}, {3.724745654421875*^9, 3.72474622425*^9}, {
   3.72474627875*^9, 3.724746404453125*^9}, {3.72474645796875*^9, 
   3.724747286890625*^9}, {3.72474743659375*^9, 3.72474744615625*^9}, {
   3.724748219625*^9, 3.72474824153125*^9}, {3.724748571296875*^9, 
   3.724748767859375*^9}, {3.724748827796875*^9, 3.724748985546875*^9}, {
   3.724749030328125*^9, 3.72474935340625*^9}, {3.724749392578125*^9, 
   3.72474940403125*^9}, {3.72474953396875*^9, 3.724749534171875*^9}, {
   3.724933434109375*^9, 3.7249334566875*^9}, {3.725083612575203*^9, 
   3.7250836374728465`*^9}, {3.7250837047713647`*^9, 
   3.7250837294974084`*^9}, {3.7250841460025396`*^9, 3.725084174082589*^9}, {
   3.725084582616107*^9, 3.7250846091829534`*^9}, {3.725084645390617*^9, 
   3.725084686153488*^9}, {3.7250847557140107`*^9, 3.7250848741338186`*^9}, {
   3.7250851570333977`*^9, 3.7250851999334736`*^9}, {3.725117752765625*^9, 
   3.725117756984375*^9}, {3.725118605578125*^9, 3.725118647203125*^9}, {
   3.725118764*^9, 3.725118789375*^9}, {3.725118830015625*^9, 
   3.7251188635625*^9}, {3.72511899275*^9, 3.725118998125*^9}, {
   3.725119073890625*^9, 3.72511909053125*^9}, {3.7251192079375*^9, 
   3.72511923503125*^9}, {3.725119278734375*^9, 3.725119295453125*^9}, {
   3.72511933775*^9, 3.725119505390625*^9}, {3.7251195509375*^9, 
   3.7251195758125*^9}, 3.725119610734375*^9, {3.725119757359375*^9, 
   3.7251197843125*^9}, {3.72512063284375*^9, 3.7251206514375*^9}, {
   3.72512075825*^9, 3.72512078003125*^9}, 3.72512148184375*^9, {
   3.725121644078125*^9, 3.72512168696875*^9}, {3.7251219778125*^9, 
   3.72512202390625*^9}, {3.725122086375*^9, 3.72512226328125*^9}, {
   3.725122296203125*^9, 3.72512231821875*^9}, {3.725122348578125*^9, 
   3.725122444875*^9}, {3.725122479265625*^9, 3.72512264971875*^9}, {
   3.725122703765625*^9, 3.72512275865625*^9}, {3.725122803015625*^9, 
   3.725122806921875*^9}, 3.725123389359375*^9, {3.725123890140625*^9, 
   3.725123893078125*^9}, {3.72512637096875*^9, 3.72512637546875*^9}, 
   3.725128232359375*^9, {3.72512826703125*^9, 3.725128269859375*^9}, {
   3.725160443125*^9, 3.72516044325*^9}, {3.725279400421875*^9, 
   3.725279427921875*^9}, {3.725280004390625*^9, 3.72528005953125*^9}, 
   3.72528108334375*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plIm", "=", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"dataOstra", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"f", ",", 
           RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plRe", "=", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"dataOstra", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"f", ",", "re"}], "}"}]}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plAbs", "=", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"dataOstra", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"f", ",", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["re", "2"], "+", 
             SuperscriptBox["im", "2"]}]]}], "}"}]}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.725121073015625*^9, {3.725123198234375*^9, 3.725123234671875*^9}, {
   3.725123289953125*^9, 3.72512329778125*^9}, 3.725124561734375*^9, 
   3.72516078690625*^9, {3.7251623665625*^9, 3.7251625090625*^9}, {
   3.725162624078125*^9, 3.72516266084375*^9}, {3.72516288815625*^9, 
   3.7251628915*^9}, {3.725162923328125*^9, 3.72516295371875*^9}, {
   3.725163197203125*^9, 3.725163254328125*^9}, {3.725163967125*^9, 
   3.72516397596875*^9}, {3.7251644923125*^9, 3.725164577*^9}, {
   3.725274651125*^9, 3.72527465584375*^9}, {3.725279524828125*^9, 
   3.725279553625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fZlom", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testDZ", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "]"}], ":=", 
   RowBox[{"0", "\[LessEqual]", "f", "\[LessEqual]", "fZlom"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dataOstram", "=", 
    RowBox[{"Select", "[", 
     RowBox[{"dataOstra", ",", "testDZ"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fs", "=", 
   RowBox[{"First", "/@", "dataOstram"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fnmax", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"First", "/@", "dataOstram"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataZbytek", "=", 
   RowBox[{"dataOstram", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"re", "-", 
        RowBox[{"Re", "[", 
         RowBox[{"zVysoke", "[", "f", "]"}], "]"}]}], ",", 
       RowBox[{"im", "-", 
        RowBox[{"Im", "[", 
         RowBox[{"zVysoke", "[", "f", "]"}], "]"}]}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dIm", "=", 
   RowBox[{"dataZbytek", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"f", ",", "im"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plIm", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"dIm", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"f", ",", 
         RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<f [Hz]\>\"", ",", "\"\<Im[z] [\[CapitalOmega]]\>\""}], 
       "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dRe", "=", 
   RowBox[{"dataZbytek", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"f", ",", "re"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plRe", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"dRe", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<f [Hz]\>\"", ",", "\"\<Re[z] [\[CapitalOmega]]\>\""}], 
       "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plAbs", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"dataZbytek", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"f", ",", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["re", "2"], "+", 
           SuperscriptBox["im", "2"]}]]}], "}"}]}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<f [Hz]\>\"", ",", "\"\<Abs[z] [\[CapitalOmega]]\>\""}], 
       "}"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.725274769234375*^9, 3.725274931640625*^9}, {
   3.725274980140625*^9, 3.725275050515625*^9}, 3.72527510703125*^9, {
   3.725275167765625*^9, 3.725275293359375*^9}, {3.725275352890625*^9, 
   3.7252754150625*^9}, {3.725277220453125*^9, 3.72527729778125*^9}, {
   3.72527768659375*^9, 3.7252777155625*^9}, {3.72527901890625*^9, 
   3.725279019703125*^9}, 3.72527905778125*^9, {3.725279169390625*^9, 
   3.72527916959375*^9}, {3.72527957715625*^9, 3.7252795823125*^9}, {
   3.725280662828125*^9, 3.72528066878125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lndIm", "=", 
   RowBox[{"dIm", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Log", "[", "f", "]"}], ",", 
       RowBox[{"Log", "[", 
        RowBox[{"-", "im"}], "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"po", "=", 
   RowBox[{"ListPlot", "[", "lndIm", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lnMinusIm", "[", "lnf_", "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"lndIm", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "lnf"}], "}"}], ",", "lnf"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"po", ",", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log", "[", "#", "]"}], ",", 
          RowBox[{"lnMinusIm", "[", 
           RowBox[{"Log", "[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "fs"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zIm", "[", "f_", "]"}], "=", 
   RowBox[{"-", 
    RowBox[{"Exp", "[", 
     RowBox[{"lnMinusIm", "[", 
      RowBox[{"Log", "[", "f", "]"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lndRe", "=", 
   RowBox[{"dRe", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "re_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Log", "[", "f", "]"}], ",", 
       RowBox[{"Log", "[", "re", "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"po", "=", 
   RowBox[{"ListPlot", "[", "lndRe", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"lndRe", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lnRe", "[", "lnf_", "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"lndRe", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "lnf"}], "}"}], ",", "lnf"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"po", ",", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log", "[", "#", "]"}], ",", 
          RowBox[{"lnRe", "[", 
           RowBox[{"Log", "[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "fs"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zRe", "[", "f_", "]"}], "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"lnRe", "[", 
     RowBox[{"Log", "[", "f", "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zZbytek", "[", "f_", "]"}], ":=", 
   RowBox[{
    RowBox[{"zRe", "[", "f", "]"}], "+", 
    RowBox[{"I", "*", 
     RowBox[{"zIm", "[", "f", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataZbytekm", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"Re", "[", 
        RowBox[{"zZbytek", "[", "#", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"zZbytek", "[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
    "fs"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plImm", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"dataZbytekm", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"f", ",", 
         RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<f [Hz]\>\"", ",", "\"\<Im[z] [\[CapitalOmega]]\>\""}], 
       "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plRem", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"dataZbytekm", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"f", ",", "re"}], "}"}]}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<f [Hz]\>\"", ",", "\"\<Re[z] [\[CapitalOmega]]\>\""}], 
       "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plIm", ",", "plImm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plRe", ",", "plRem"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.725276490234375*^9, 3.725276657140625*^9}, {
   3.725276687265625*^9, 3.725276730921875*^9}, {3.725276768015625*^9, 
   3.72527686328125*^9}, {3.725277029953125*^9, 3.725277034640625*^9}, 
   3.7252773699375*^9, {3.72527741265625*^9, 3.725277579078125*^9}, {
   3.725277776375*^9, 3.72527782421875*^9}, {3.7252778659375*^9, 
   3.725277937328125*^9}, {3.725277987046875*^9, 3.725278144828125*^9}, {
   3.725278241140625*^9, 3.72527838446875*^9}, {3.725278430125*^9, 
   3.72527848096875*^9}, {3.725278550296875*^9, 3.725278859265625*^9}, {
   3.725278911515625*^9, 3.725278972625*^9}, 3.7252790294375*^9, {
   3.725279083640625*^9, 3.725279110734375*^9}, {3.72527918609375*^9, 
   3.725279206078125*^9}, {3.725279254171875*^9, 3.725279265140625*^9}, {
   3.7252795916875*^9, 3.72527959271875*^9}, {3.7252796294375*^9, 
   3.725279630296875*^9}, {3.725280013234375*^9, 3.725280019921875*^9}, 
   3.7252800504375*^9, 3.72528043784375*^9, {3.72528050146875*^9, 
   3.725280505234375*^9}, {3.7252807298125*^9, 3.725280770671875*^9}, 
   3.725280806125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"zCelk", "[", "f_", "]"}], ":=", 
   RowBox[{
    RowBox[{"zZbytek", "[", "f", "]"}], "+", 
    RowBox[{"zVysoke", "[", "f", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bodCelk", "[", "f_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"zCelk", "[", "f", "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"zCelk", "[", "f", "]"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2c", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bodCelk", "[", "f", "]"}], "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"re", ",", 
         RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "fmin", ",", "fmax"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "500"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plOstra", ",", "pl2c"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodyCelk", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"Re", "[", 
        RowBox[{"zCelk", "[", "#", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"zCelk", "[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
    "fc"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plC", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"bodyCelk", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"re", ",", 
         RowBox[{"-", "im"}]}], "}"}]}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Re[z] \[CapitalOmega]\>\"", ",", 
        "\"\<-Im[z] \[CapitalOmega]\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plOstra", ",", "plC"}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.72527983421875*^9, 3.72527984503125*^9}, {
  3.72527987778125*^9, 3.725279924015625*^9}, {3.725280117640625*^9, 
  3.725280206453125*^9}, {3.725280323265625*^9, 3.725280329734375*^9}, {
  3.725280444546875*^9, 3.725280477671875*^9}, {3.725280521421875*^9, 
  3.725280637875*^9}, {3.725280693859375*^9, 3.725280697703125*^9}}],

Cell[BoxData[
 RowBox[{"zCelk", "[", "f", "]"}]], "Input",
 CellChangeTimes->{{3.725280862453125*^9, 3.725280863625*^9}}]
},
WindowSize->{1080, 617},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> True}},
Magnification->1.5000001192092896`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 330, 9, 98, "Input"],
Cell[878, 31, 1048, 29, 185, "Input"],
Cell[1929, 62, 1098, 28, 98, "Input"],
Cell[3030, 92, 1179, 29, 125, "Input"],
Cell[4212, 123, 6831, 171, 642, "Input"],
Cell[11046, 296, 2533, 65, 266, "Input"],
Cell[13582, 363, 4487, 121, 535, "Input"],
Cell[18072, 486, 6237, 177, 611, "Input"],
Cell[24312, 665, 2897, 81, 395, "Input"],
Cell[27212, 748, 121, 2, 43, "Input"]
}
]
*)

(* End of internal cache information *)
